;================================================

;================================================
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"   
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/wrf/WRFUserARW.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl" 
begin
;************************************************
; open file and read in data
;************************************************

;*************************
  geof1  = addfile("/home/user/chensy3/data/zhangyue/WPSV391_2020-03/geo_em.d01.nc","r")
  lat1_sim   = geof1->XLAT_M
  lon1_sim   = geof1->XLONG_M
  lat1=lat1_sim(0,:,0)
  lon1=lon1_sim(0,0,:)

  nday=6
  plot=new(nday,graphic)
  plot_t=new(nday,graphic)


loc=wrf_user_ll_to_ij(geof1, (/78,146/), (/25,51/), True)
Xstart=loc(0,0)
Xend=loc(0,1)
Ystart=loc(1,0)
Yend=loc(1,1)
;************************************************
wks = gsn_open_wks("png","6_zoom")     ; open a workstation
;========================================
path="/home/user/chensy3/csr4/zhangyue/wrfdata/wrfout/ETL_data/dustdeposition/2020-03/"
filename="wrfout_dust_dry_wet_deposition_2020_03_1*.nc"
outfiles=systemfunc("ls " +path+filename)
f=addfiles(outfiles+".nc","r")

ListSetType(f,"join")
var = wrf_user_getvar(f(:),"DDP",-1)

    
;=======================================
  res                   = True              ; plot mods desired
  res@Footer = False
  res@InitTime    = False
  res@FieldTitle=""
  res@NoHeaderFooter           = True            ; Switch headers and footers off
 
;============================================

   res@cnFillPalette="WhiteBlueGreenYellowRed";用该色板填色
   res@cnLevelSelectionMode ="ExplicitLevels"
   res@cnLevels=(/5,10,15,25,30,35,40,45,50,100,200,300,400,500,600,700/);(/0.1,1,10,50,100,500,1000/)
   ;res@cnFillColors = (/0,66,98,114,146,162,178,194/)

  
;============================================
  res@cnLineLabelsOn       = False
  res@pmLabelBarWidthF = 0.9
  res@pmLabelBarHeightF=0.3
  res@lbLabelFontHeightF=0.03
  res@lbBoxSeparatorLinesOn=False
  res@cnFillOn              = True            ; color plot desired
  res@cnLinesOn             = False    
 
  ;res@gsnLeftString=""

  pltres=True
  pltres@PanelPlot = True      ; Indicate these plots are to be paneled.

  map_res = True
  map_res@gsnDraw=False
  map_res@gsnFrame=False
  map_res@mpDataSetName  = "/home/data/data-CSR4/chenyu/mapdata/Earth..4"
  map_res@mpDataBaseVersion="MediumRes"
  map_res@mpOutlineOn = True
  map_res@mpAreaMaskingOn       = True
  ;map_res@mpMaskAreaSpecifiers  = (/"China:states"/)
  ;map_res@mpOutlineSpecifiers = (/"China:states"/)
  map_res@mpNationalLineColor        = "black"
  map_res@mpCountyLineColor      = "black"
  map_res@mpProvincialLineColor  ="black"
  map_res@mpGeophysicalLineColor="black"
  map_res@mpGeophysicalLineThicknessF =2.5
  map_res@mpNationalLineThicknessF=2.5
  map_res@tmXBLabelFontHeightF=0.025
  map_res@tmYLLabelFontHeightF=0.025
  map_res@tmBorderThicknessF=6

    ;限制wrfout的输出区域
  map_res@ZoomIn=True
  map_res@Xstart=Xstart
  map_res@Xend=Xend
  map_res@Ystart=Ystart
  map_res@Yend=Yend
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
   resb                   = True              ; plot mods desired
   resb@Footer = False
   resb@InitTime    = False
   resb@FieldTitle=""

   resb@NoHeaderFooter           = True            ; Switch headers and footers off

   resb@cnFillPalette="temp_diff_18lev"
   resb@cnLevelSelectionMode ="ExplicitLevels"

   Levels = (/-100,-90,-80,-70,-60,-50,-40,-30,-20,-10,-5,5,10,20,30,40,50,60,70,80,90,100/)
   resb@cnLevels = Levels
   ;resb@cnFillColors = (/2,3,4,5,6,7,8,9,0,12,13,14,15,16,17,18,19/)

   resb@cnLineLabelsOn       = False
   resb@pmLabelBarWidthF = 0.9
   resb@pmLabelBarHeightF=0.3

   resb@cnFillOn              = True            ; color plot desired
   resb@cnLinesOn             = False
   resb@lbLabelFontHeightF=0.03
   resb@lbBoxSeparatorLinesOn=False
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

   var1=var(0,:,:)-0.
   plot_t(0)=wrf_contour(geof1,wks,var1(Ystart:Yend,Xstart:Xend),res)
   plot(0) = wrf_map_overlays(geof1,wks,(/plot_t(0)/),pltres,map_res)
   
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::;;   
   varb=new((/5,239,289/),float)
   
   do m=1,5
   
   varb(m-1,:,:)=var(m,:,:)-var(0,:,:)
   printMinMax(varb,False)

   plot_t(m)=wrf_contour(geof1,wks,varb(m-1,Ystart:Yend,Xstart:Xend),resb)
   plot(m) = wrf_map_overlays(geof1,wks,(/plot_t(m)/),pltres,map_res)

   end do

;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
   shp1="/home/user/chensy3/csr4/chenyu/NCL/china/mygeodata/china.shp"
  lnres1        = True
  lnres1@gsLineColor      ="black"
  lnres1@gsLineThicknessF = 2.5;3.5;          ; 2x thickness
  shp_plot1     = gsn_add_shapefile_polylines(wks,plot(0),shp1,lnres1)
  shp_plot2     = gsn_add_shapefile_polylines(wks,plot(1),shp1,lnres1)
  shp_plot3     = gsn_add_shapefile_polylines(wks,plot(2),shp1,lnres1)
  shp_plot4     = gsn_add_shapefile_polylines(wks,plot(3),shp1,lnres1)
  shp_plot5     = gsn_add_shapefile_polylines(wks,plot(4),shp1,lnres1)
  shp_plot6     = gsn_add_shapefile_polylines(wks,plot(5),shp1,lnres1) 

;=====================TOTAL===================
pres                  = True
pres@gsnMaximize=True

pres@gsnPanelScalePlotIndex	= 0
pres@gsnPanelYWhiteSpacePercent = 0
pres@gsnPanelXWhiteSpacePercent = 0

pres@gsnPanelFigureStrings = (/"(f)"/)
pres@gsnPanelFigureStringsFontHeightF = 0.035
pres@amOrthogonalPosF    =-0.5
pres@amParallelPosF      =-0.5
pres@amJust = "TopLeft"
gsn_panel(wks,plot(5),(/1,1/),pres)
  
  
print("Game Over")
end
